<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-book me-2"></i>Kelola Pelatihan
    </h2>
    <a href="<?= base_url('admin/training/create') ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle me-1"></i>Tambah Pelatihan
    </a>
</div>

<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle me-2"></i><?= session()->getFlashdata('success') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="bi bi-exclamation-triangle me-2"></i><?= session()->getFlashdata('error') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<!-- Search and Filter Section -->
<div class="admin-card">
    <form method="GET" action="<?= base_url('admin/training') ?>" class="row g-3">
        <div class="col-md-3">
            <label for="search" class="form-label">Cari Pelatihan</label>
            <input type="text" class="form-control" id="search" name="search" 
                   value="<?= esc($search) ?>" placeholder="Cari nama pelatihan...">
        </div>
        <div class="col-md-2">
            <label for="penyelenggara" class="form-label">Penyelenggara</label>
            <input type="text" class="form-control" id="penyelenggara" name="penyelenggara" 
                   value="<?= esc($filter['penyelenggara']) ?>" placeholder="Filter penyelenggara...">
        </div>
        <div class="col-md-2">
            <label for="tanggal_mulai" class="form-label">Tanggal Mulai</label>
            <input type="date" class="form-control" id="tanggal_mulai" name="tanggal_mulai" 
                   value="<?= esc($filter['tanggal_mulai']) ?>">
        </div>
        <div class="col-md-2">
            <label for="tanggal_selesai" class="form-label">Tanggal Selesai</label>
            <input type="date" class="form-control" id="tanggal_selesai" name="tanggal_selesai" 
                   value="<?= esc($filter['tanggal_selesai']) ?>">
        </div>
        <div class="col-md-2">
            <label for="sort" class="form-label">Sort By</label>
            <select class="form-select" id="sort" name="sort">
                <option value="urutan" <?= $sort === 'urutan' ? 'selected' : '' ?>>Urutan</option>
                <option value="nama_pelatihan" <?= $sort === 'nama_pelatihan' ? 'selected' : '' ?>>Nama Pelatihan</option>
                <option value="tanggal_mulai" <?= $sort === 'tanggal_mulai' ? 'selected' : '' ?>>Tanggal Mulai</option>
            </select>
        </div>
        <div class="col-md-1 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">
                <i class="bi bi-funnel"></i>
            </button>
        </div>
    </form>
</div>

<!-- Training Table -->
<div class="admin-card">
    <?php if (empty($training)): ?>
        <div class="alert alert-info text-center">
            <i class="bi bi-info-circle me-2"></i>Tidak ada pelatihan yang ditemukan.
        </div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Urutan</th>
                        <th>Nama Pelatihan</th>
                        <th>Penyelenggara</th>
                        <th>Tanggal</th>
                        <th>Sertifikat</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $no = ($pager->getCurrentPage() - 1) * 10 + 1; ?>
                    <?php foreach ($training as $t): ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td><?= esc($t['urutan']) ?></td>
                            <td><?= esc($t['nama_pelatihan']) ?></td>
                            <td><?= esc($t['penyelenggara'] ?? '-') ?></td>
                            <td>
                                <?php if ($t['tanggal_mulai'] && $t['tanggal_selesai']): ?>
                                    <?= date('d/m/Y', strtotime($t['tanggal_mulai'])) ?> - <?= date('d/m/Y', strtotime($t['tanggal_selesai'])) ?>
                                <?php elseif ($t['tanggal_mulai']): ?>
                                    <?= date('d/m/Y', strtotime($t['tanggal_mulai'])) ?>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($t['sertifikat']): ?>
                                    <i class="bi bi-file-earmark-pdf text-success"></i> Ada
                                <?php else: ?>
                                    <span class="text-white">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="<?= base_url('admin/training/edit/' . $t['id']) ?>" 
                                   class="btn btn-sm btn-warning btn-action">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <a href="<?= base_url('admin/training/delete/' . $t['id']) ?>" 
                                   class="btn btn-sm btn-danger btn-action"
                                   onclick="return confirm('Yakin ingin menghapus pelatihan ini?')">
                                    <i class="bi bi-trash"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if ($pager->getLastPage() > 1): ?>
            <nav aria-label="Page navigation" class="mt-4">
                <ul class="pagination">
                    <?php if ($pager->getCurrentPage() > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= base_url('admin/training?page=' . ($pager->getCurrentPage() - 1) . '&search=' . urlencode($search) . '&penyelenggara=' . urlencode($filter['penyelenggara']) . '&tanggal_mulai=' . urlencode($filter['tanggal_mulai']) . '&tanggal_selesai=' . urlencode($filter['tanggal_selesai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                <i class="bi bi-chevron-left"></i>
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php for ($i = 1; $i <= $pager->getLastPage(); $i++): ?>
                        <li class="page-item <?= $i == $pager->getCurrentPage() ? 'active' : '' ?>">
                            <a class="page-link" href="<?= base_url('admin/training?page=' . $i . '&search=' . urlencode($search) . '&penyelenggara=' . urlencode($filter['penyelenggara']) . '&tanggal_mulai=' . urlencode($filter['tanggal_mulai']) . '&tanggal_selesai=' . urlencode($filter['tanggal_selesai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                Part <?= $i ?>
                            </a>
                        </li>
                    <?php endfor; ?>
                    
                    <?php if ($pager->getCurrentPage() < $pager->getLastPage()): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= base_url('admin/training?page=' . ($pager->getCurrentPage() + 1) . '&search=' . urlencode($search) . '&penyelenggara=' . urlencode($filter['penyelenggara']) . '&tanggal_mulai=' . urlencode($filter['tanggal_mulai']) . '&tanggal_selesai=' . urlencode($filter['tanggal_selesai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                <i class="bi bi-chevron-right"></i>
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
            </nav>
        <?php endif; ?>
    <?php endif; ?>
</div>
<?= $this->endSection() ?>


